     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions
     __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _XT_OSC & _WRT_ENABLE_ON & _LVP_ON & _DEBUG_OFF & _CPD_OFF

offset    EQU       0x20
temp      EQU       0x21
          ORG       0x0000

;************ initial *******************
init     bsf     STATUS,RP0                      ; select bank 1
         movlw   .25                     ; BAUD rate 9600
         movwf   SPBRG
         clrf    TXSTA                   ; 8 bits data ,no,1 stop
         BSF     TXSTA,BRGH              ; HI SPEED
         bcf     STATUS,RP0              ; select bank 0
         bsf     RCSTA,SPEN              ; Asynchronous serial port enable
         bsf     RCSTA,CREN              ; continuous receive
         bsf     STATUS,RP0              ; select bank 1
         bsf     TXSTA,TXEN              ; Transmit enable
         bcf     STATUS,RP0              ; select bank 0
;********** start to send **********************
         clrf    offset                  ; load offset of character table
start    movf    offset,w       
         call    TAB
         addlw   0                       ; Character = 00 ?
         btfsc   STATUS,Z                ; Character = 00 ?
         goto    wait2                   ; Yes , Z = 1
                                         ; No  , Z = 0
         movwf   TXREG                   ; Send recent data to TX 
wait1    movlw   TXSTA                   ; 
         movwf   FSR                     ; FSR <= TXSTA
         btfss   INDF,1                  ; check TRMT bit in TXSTA (FSR)
         goto    wait1                   ; TXREG full  or TRMT = 0
         incf    offset,f                ; TXREG empty  or TRMT = 1
         goto    start                   ; Send again

;********** start to receive *******************          
wait2    btfss   PIR1,RCIF               ; Check RCIF  bit in PIR1 register
         goto    wait2                   ; RCREG empty or RCIF = 0
         movf    RCREG,w                 ; RCREG full or RCIF = 1
         movwf   TXREG
         goto    wait2
;********* Tebel of message ********************  
TAB      addwf   PCL                   ; Move offset to PC lower
         retlw   "E"
         retlw   "T"
         retlw   "T"
         retlw   " "
         retlw   "C"
         retlw   "O"
         retlw   ","
         retlw   "L" 
         retlw   "T"
         retlw   "D" 
         retlw   0xA
         retlw   0xD
         retlw   0

          END

